<?php

defined('PF_VERSION') OR exit('Access denied');
define('PLUGIN_LANGUAGE', __('Page', 'page'));

class Page_Plugin extends Pf_Plugin
{

    public $name = PLUGIN_LANGUAGE;
    public $version = '1.0';
    public $author = 'PageFlex Team';
    public $description = 'This is the page description';

    public function activate()
    {
        $db = Pf::database();
        $sql = "DROP TABLE IF EXISTS `pf_pages`;";
        $db->query($sql);
        $db->query("CREATE TABLE IF NOT EXISTS `pf_pages` (
                    `id` int(11) NOT NULL AUTO_INCREMENT,
                    `page_title` varchar(255) NOT NULL,
                    `page_content` text NOT NULL,
                    `page_url` varchar(255) NOT NULL,
                    `page_layout` varchar(50) NOT NULL,
                    `page_type` int(11) NOT NULL,
                    `page_author` int(11) NOT NULL,
                    `page_meta_title` varchar(70) NOT NULL,
                    `page_meta_keywords` varchar(255) NOT NULL,
                    `page_meta_description` varchar(156) NOT NULL,
                    `page_created_date` datetime NOT NULL,
                    `page_modified_date` datetime NOT NULL,
                    `page_system` tinyint(1) NOT NULL,
                    `page_status` tinyint(1) NOT NULL,
                    PRIMARY KEY (`id`)
                  ) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=28;"
        );
    }

    public function deactivate()
    {
        $db = Pf::database();
        $db->query("DROP TABLE pf_pages");
    }

    public function admin_init()
    {
        require ABSPATH . '/includes/common/plugin/helpers/permission.php';
        if (plugin_check_acl(array(1, 2))) {
            $this->admin_menu('fa fa-book', __('Page', 'page'), 'page', 'plugin_page_manager');
        }
    }

    function plugin_page_manager()
    {
        $this->js('admin/themes/default/assets/bootstrap-notification/js/jquery/jquery.easing.1.3.js');
        $this->js('admin/themes/default/assets/bootstrap-notification/js/bootstrap.notification.js');
        $this->js('admin/themes/default/assets/tinymce/js/tinymce/tinymce.min.js');

        $this->css('page/assets/page.css', __FILE__);
        $this->js('page/assets/bootbox.min.js', __FILE__);
        $this->js('includes/common/plugin/assets/base.js?t=95');
        $this->js('page/assets/page.js?t=' . uniqid(), __FILE__);
        require_once abs_plugin_path(__FILE__) . '/page/index.php';
    }

}
